program define table7_dynan

* create a table showing how leverage has evolved for FINAL draft of the 
* paper (hope this works!)

  clear all
  global mydate = subinstr("${S_DATE}"," ","-",.)
  capture log close
  quietly log using logfiles/table7_dynan_$mydate, replace
  capture log close
  file open myfile using "logfiles/table7_dynan_$mydate.txt", write replace
  set more off

* this dataset is generated by make_bpea_data.do

  use bpea_data
  sort persid yr

* for test purposes
* drop if _n > 10000

* create the sample variables:  

  quietly gen temp1 = (wgt>=0 & wgt~=.)
  quietly gen temp4 = ((temp1 + l2.temp1 + l4.temp1) == 3)
  quietly replace temp4 = 0 if yr ~= 2009
  by persid:  egen cons_samp = max(temp4)
  drop temp*

  quietly gen temp1 = reth
  quietly replace temp1 = 0 if yr~=2009 | temp1==.
  by persid:  egen retsamp = max(temp1)
  drop temp1

  quietly gen temp1 = hboom6
  quietly replace temp1 = 0 if hboom6==. 
  by persid:  egen boomsamp = max(temp1)
  drop temp1

  quietly gen temp1 = homeown
  quietly replace temp1 = 0 if yr~=2007 | temp1==.
  by persid:  egen hosamp = max(temp1)
  drop temp1 

* let's include everyone!

  *gen insamp = (cons_samp==1) & (retsamp==0) & (hosamp==1)
  *drop if insamp == 0
  quietly replace mort_to_hv = 0 if mort_to_hv == . & hage~=.

* generate comparison variables

  forvalues yyyy = 2009(2)2011 {
    forvalues bbbb = 2003(2)2007 {
      local ddd = `yyyy' - `bbbb'
      gen bench = l`ddd'.mort_to_hv
      replace bench = .9 if (homeown - l`ddd'.homeown == 1) 
      foreach nnn in 0 10 20 30 40 50 {
        quietly gen lev`yyyy'_gt_bench`bbbb'p`nnn' = (mort_to_hv > (bench + `nnn'/100)) if yr==`yyyy'
        quietly replace lev`yyyy'_gt_bench`bbbb'p`nnn' = . if mort_to_hv==. | bench == . 
      }
      drop bench
    }
  }

  file write myfile _column(43) "      Table 7" _n 
  file write myfile _column(43) "Deleveraging Progress" _n _n _n
  
  local r1 "  Benchmark is 2003 leverage:"
  local r2 "    Share with lev-benchmark > 0"
  local r3 "    Share with lev-benchmark > .1"
  local r4 "    Share with lev-benchmark > .2"
  local r5 "    Share with lev-benchmark > .3"
  local r6 "    Share with lev-benchmark > .4"
  local r7 "    Share with lev-benchmark > .5"
  local r8 "  Benchmark is 2005 leverage:"
  local r9 "    Share with lev-benchmark > 0"
  local r10 "    Share with lev-benchmark > .1"
  local r11 "    Share with lev-benchmark > .2"
  local r12 "    Share with lev-benchmark > .3"
  local r13 "    Share with lev-benchmark > .4"
  local r14 "    Share with lev-benchmark > .5"
  local r15 "  Benchmark is 2007 leverage:"
  local r16 "    Share with lev-benchmark > 0"
  local r17 "    Share with lev-benchmark > .1"
  local r18 "    Share with lev-benchmark > .2"
  local r19 "    Share with lev-benchmark > .3"
  local r20 "    Share with lev-benchmark > .4"
  local r21 "    Share with lev-benchmark > .5"

  file write myfile _column(20) %-20s ///
        _column(35) "Based on 2009 data" ///
        _column(55) "Based on 2011 data" ///
        _n _n

  file write myfile _column(0) %-20s "`r1'" _n
  local rrr = 2
  forvalues bbbb = 2003(2)2007 {
     foreach nnn in 0 10 20 30 40 50 {
       forvalues yyyy = 2009(2)2011 {
         quietly summ lev`yyyy'_gt_bench`bbbb'p`nnn' [w=wgt] if yr==`yyyy'
         scalar stat`yyyy' = r(mean)
       }
       file write myfile _column(0) %-20s "`r`rrr''" ///
        _column(42) %6.3f (stat2009) ///
        _column(62) %6.3f (stat2011) ///
        _n
        if inlist(`rrr',7,14) {
                file write myfile _n
                local rrr = `rrr' + 1
                file write myfile %-20s "`r`rrr''" _n
             }
        local rrr = `rrr'+1
      }
    }
        
   file write myfile _n
   file write myfile _column(0) %-100s "Note.  Sample includes all households for which comparison can be done. " _n
   file write myfile _column(0) %-100s "For new homeowners, the benchmark is .9. Leverage = mortgage leverage." _n
   file close myfile
    
capture log close

end
